/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.storage;

import com.ca.mfaas.message.core.DuplicateMessageException;
import com.ca.mfaas.message.template.MessageTemplate;
import com.ca.mfaas.message.template.MessageTemplates;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MessageTemplateStorage {
    private final Map<String, MessageTemplate> messageTemplateMap = new HashMap<String, MessageTemplate>();

    public Optional<MessageTemplate> getMessageTemplate(String key) {
        return Optional.ofNullable(this.messageTemplateMap.get(key));
    }

    public void addMessageTemplates(MessageTemplates messages) {
        messages.getMessages().forEach(this::addMessageTemplateToStorage);
    }

    private void addMessageTemplateToStorage(MessageTemplate message) {
        if (this.messageTemplateMap.containsKey(message.getKey())) {
            String exceptionMessage = String.format("Message with key '%s' already exists", message.getKey());
            throw new DuplicateMessageException(exceptionMessage);
        }
        this.messageTemplateMap.put(message.getKey(), message);
    }
}

