/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.message.log;

import com.ca.mfaas.message.core.Message;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.core.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApimlLogger {
    private final MessageService messageService;
    private final Logger logger;

    public ApimlLogger(Class<?> clazz, MessageService messageService) {
        this.messageService = messageService;
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public static ApimlLogger of(Class<?> clazz, MessageService messageService) {
        return new ApimlLogger(clazz, messageService);
    }

    public static ApimlLogger empty() {
        return new ApimlLogger(ApimlLogger.class, null);
    }

    public void log(String key, Object ... parameters) {
        if (this.messageService != null) {
            Message message = this.messageService.createMessage(key, parameters);
            this.log(message.getMessageTemplate().getType(), message.mapToLogMessage(), new Object[0]);
        }
    }

    public void log(MessageType messageType, String text, Object ... arguments) {
        if (messageType == null || text == null || arguments == null) {
            throw new IllegalArgumentException("Parameters can't be null");
        }
        switch (messageType) {
            case TRACE: {
                this.logger.trace(text, arguments);
                break;
            }
            case DEBUG: {
                this.logger.debug(text, arguments);
                break;
            }
            case INFO: {
                this.logger.info(text, arguments);
                break;
            }
            case WARNING: {
                this.logger.warn(text, arguments);
                break;
            }
            case ERROR: {
                this.logger.error(text, arguments);
                break;
            }
            default: {
                this.logger.warn("The following message contains invalid message type.");
                this.logger.info(text, arguments);
            }
        }
    }
}

