/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.eurekaservice.client.util;

import com.ca.mfaas.config.ApiInfo;
import com.ca.mfaas.product.routing.RoutedService;
import com.ca.mfaas.product.routing.RoutedServices;
import com.ca.mfaas.product.utils.UrlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaMetadataParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EurekaMetadataParser.class);

    public List<ApiInfo> parseApiInfo(Map<String, String> eurekaMetadata) {
        HashMap apiInfo = new HashMap();
        eurekaMetadata.entrySet().stream().filter(metadata -> ((String)metadata.getKey()).startsWith("apiml.apiInfo")).forEach(metadata -> {
            String[] keys = ((String)metadata.getKey()).split("\\.");
            if (keys.length == 4) {
                apiInfo.putIfAbsent(keys[2], new ApiInfo());
                ApiInfo api = (ApiInfo)apiInfo.get(keys[2]);
                switch (keys[3]) {
                    case "apiId": {
                        api.setApiId((String)metadata.getValue());
                        break;
                    }
                    case "gatewayUrl": {
                        api.setGatewayUrl((String)metadata.getValue());
                        break;
                    }
                    case "version": {
                        api.setVersion((String)metadata.getValue());
                        break;
                    }
                    case "swaggerUrl": {
                        api.setSwaggerUrl((String)metadata.getValue());
                        break;
                    }
                    case "documentationUrl": {
                        api.setDocumentationUrl((String)metadata.getValue());
                        break;
                    }
                    default: {
                        log.warn("Invalid parameter in metadata: {}", metadata);
                    }
                }
            }
        });
        return new ArrayList<ApiInfo>(apiInfo.values());
    }

    public RoutedServices parseRoutes(Map<String, String> eurekaMetadata) {
        RoutedServices routes = new RoutedServices();
        this.parseToListRoute(eurekaMetadata).forEach(routes::addRoutedService);
        return routes;
    }

    public List<RoutedService> parseToListRoute(Map<String, String> eurekaMetadata) {
        HashMap routeMap = new HashMap();
        return eurekaMetadata.entrySet().stream().filter(this::filterMetadata).map(metadata -> this.mapMetadataToRoutedService((Map.Entry<String, String>)metadata, routeMap)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean filterMetadata(Map.Entry<String, String> metadata) {
        return metadata.getKey().startsWith("apiml.routes") && (metadata.getKey().endsWith("gatewayUrl") || metadata.getKey().endsWith("serviceUrl"));
    }

    private RoutedService mapMetadataToRoutedService(Map.Entry<String, String> metadata, Map<String, String> routeMap) {
        String routeKey = metadata.getKey();
        String routeURL = metadata.getValue();
        String[] routeKeys = routeKey.split("\\.");
        if (routeKeys.length != 4) {
            return null;
        }
        String subServiceId = routeKeys[2];
        String routeKeyURL = routeKeys[3];
        return this.processUrls(routeMap, routeKeyURL, subServiceId, routeURL);
    }

    private RoutedService processUrls(Map<String, String> routeMap, String routeKeyURL, String subServiceId, String routeURL) {
        if (routeKeyURL.equals("gatewayUrl")) {
            String gatewayURL = UrlUtils.removeFirstAndLastSlash(routeURL);
            if (routeMap.containsKey(subServiceId)) {
                String serviceUrl = routeMap.get(subServiceId);
                routeMap.remove(subServiceId);
                return new RoutedService(subServiceId, gatewayURL, serviceUrl);
            }
            routeMap.put(subServiceId, gatewayURL);
        }
        if (routeKeyURL.equals("serviceUrl")) {
            String serviceURL = UrlUtils.addFirstSlash(routeURL);
            if (routeMap.containsKey(subServiceId)) {
                String gatewayUrl = routeMap.get(subServiceId);
                routeMap.remove(subServiceId);
                return new RoutedService(subServiceId, gatewayUrl, serviceURL);
            }
            routeMap.put(subServiceId, serviceURL);
        }
        return null;
    }
}

