/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.security;

import com.ca.mfaas.security.HttpsConfig;
import com.ca.mfaas.security.HttpsConfigError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String SAFKEYRING = "safkeyring";

    public static String readSecret(HttpsConfig config) {
        if (config.getKeyStore() != null) {
            try {
                Key key = SecurityUtils.loadKey(config);
                if (key == null) {
                    throw new UnrecoverableKeyException(String.format("No key with private key entry could be used in the keystore. Provided key alias: %s", config.getKeyAlias() == null ? "<not provided>" : config.getKeyAlias()));
                }
                return Base64.getEncoder().encodeToString(key.getEncoded());
            }
            catch (UnrecoverableKeyException e) {
                log.error("Error reading secret key: {}", (Object)e.getMessage(), (Object)e);
                throw new HttpsConfigError("Error reading secret key: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, config);
            }
        }
        return null;
    }

    public static Key loadKey(HttpsConfig config) {
        if (config.getKeyStore() != null) {
            try {
                KeyStore ks = SecurityUtils.loadKeyStore(config);
                char[] keyPasswordInChars = config.getKeyPassword() == null ? null : config.getKeyPassword().toCharArray();
                Key key = null;
                key = config.getKeyAlias() != null ? ks.getKey(config.getKeyAlias(), keyPasswordInChars) : SecurityUtils.findFirstSecretKey(ks, keyPasswordInChars);
                return key;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                String errorMessage = "Error loading secret key: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                throw new HttpsConfigError(errorMessage, (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, config);
            }
        }
        return null;
    }

    private static Key findFirstSecretKey(KeyStore keyStore, char[] keyPasswordInChars) throws KeyStoreException, NoSuchAlgorithmException {
        Key key = null;
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            try {
                key = keyStore.getKey(alias, keyPasswordInChars);
                if (key == null) continue;
                break;
            }
            catch (UnrecoverableKeyException uke) {
                log.debug("Key with alias {} could not be used: {}", (Object)alias, (Object)uke.getMessage());
            }
        }
        return key;
    }

    public static PublicKey loadPublicKey(HttpsConfig config) {
        if (config.getKeyStore() != null) {
            try {
                KeyStore ks = SecurityUtils.loadKeyStore(config);
                Certificate cert = null;
                if (config.getKeyAlias() != null) {
                    cert = ks.getCertificate(config.getKeyAlias());
                } else {
                    String alias;
                    Enumeration<String> e = ks.aliases();
                    while (e.hasMoreElements() && (cert = ks.getCertificate(alias = e.nextElement())) == null) {
                    }
                }
                if (cert != null) {
                    return cert.getPublicKey();
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                String errorMessage = "Error loading public key: " + e.getMessage();
                log.error(errorMessage, (Throwable)e);
                throw new HttpsConfigError(errorMessage, (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, config);
            }
        }
        return null;
    }

    public static Key findPrivateKeyByPublic(HttpsConfig config, byte[] publicKey) {
        if (config.getKeyStore() != null) {
            try {
                String alias;
                Certificate cert;
                KeyStore ks = SecurityUtils.loadKeyStore(config);
                char[] keyPasswordInChars = config.getKeyPassword() == null ? null : config.getKeyPassword().toCharArray();
                Key key = null;
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements() && (!Arrays.equals((cert = ks.getCertificate(alias = e.nextElement())).getPublicKey().getEncoded(), publicKey) || (key = ks.getKey(alias, keyPasswordInChars)) == null)) {
                }
                return key;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                log.error("Error loading secret key: {}", (Object)e.getMessage(), (Object)e);
                throw new HttpsConfigError("Error loading secret key: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, config);
            }
        }
        return null;
    }

    public static KeyStore loadKeyStore(HttpsConfig config) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        InputStream inputStream;
        KeyStore ks = KeyStore.getInstance(config.getKeyStoreType());
        if (config.getKeyStore().startsWith(SAFKEYRING)) {
            URL url = SecurityUtils.keyRingUrl(config.getKeyStore(), config.getTrustStore());
            inputStream = url.openStream();
        } else {
            File keyStoreFile = new File(config.getKeyStore());
            inputStream = new FileInputStream(keyStoreFile);
        }
        ks.load(inputStream, config.getKeyStorePassword() == null ? null : config.getKeyStorePassword().toCharArray());
        return ks;
    }

    public static URL keyRingUrl(String uri, String trustStore) throws MalformedURLException {
        if (!uri.startsWith("safkeyring:////")) {
            throw new MalformedURLException("Incorrect key ring format: " + trustStore + ". Make sure you use format safkeyring:////userId/keyRing");
        }
        return new URL(SecurityUtils.replaceFourSlashes(uri));
    }

    public static String replaceFourSlashes(String storeUri) {
        return storeUri == null ? null : storeUri.replaceFirst("////", "//");
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        KeyPair kp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
            kpg.initialize(keySize);
            kp = kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return kp;
    }

    @Generated
    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

