/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.error.impl;

import com.ca.mfaas.error.ErrorService;
import com.ca.mfaas.error.MessageLoadException;
import com.ca.mfaas.error.impl.ErrorMessage;
import com.ca.mfaas.error.impl.ErrorMessageStorage;
import com.ca.mfaas.error.impl.ErrorMessages;
import com.ca.mfaas.rest.response.ApiMessage;
import com.ca.mfaas.rest.response.Message;
import com.ca.mfaas.rest.response.MessageType;
import com.ca.mfaas.rest.response.impl.BasicApiMessage;
import com.ca.mfaas.rest.response.impl.BasicMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ErrorServiceImpl
implements ErrorService {
    private static final String COMMON_MESSAGES = "/mfs-common-messages.yml";
    private static final String INVALID_KEY_MESSAGE = "com.ca.mfaas.common.invalidMessageKey";
    private static final String INVALID_MESSAGE_TEXT_FORMAT = "com.ca.mfaas.common.invalidMessageTextFormat";
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorServiceImpl.class);
    private final ErrorMessageStorage messageStorage = new ErrorMessageStorage();

    public ErrorServiceImpl() {
        this.loadMessages(COMMON_MESSAGES);
    }

    public ErrorServiceImpl(String messagesFilePath) {
        this();
        this.loadMessages(messagesFilePath);
    }

    @Override
    public ApiMessage createApiMessage(String key, Object ... parameters) {
        Message message = this.createMessage(key, parameters);
        return new BasicApiMessage(Collections.singletonList(message));
    }

    @Override
    public ApiMessage createApiMessage(String key, List<Object[]> parameters) {
        List<Message> messageList = parameters.stream().filter(Objects::nonNull).map(ob -> this.createMessage(key, ob)).collect(Collectors.toList());
        return new BasicApiMessage(messageList);
    }

    @Override
    public void loadMessages(String messagesFilePath) {
        try (InputStream in = ErrorServiceImpl.class.getResourceAsStream(messagesFilePath);){
            Yaml yaml = new Yaml();
            ErrorMessages applicationMessages = (ErrorMessages)yaml.loadAs(in, ErrorMessages.class);
            this.messageStorage.addMessages(applicationMessages);
        }
        catch (IOException | YAMLException e) {
            throw new MessageLoadException("There is problem with reading application messages file: " + messagesFilePath, e);
        }
    }

    private Message createMessage(String key, Object ... parameters) {
        String text;
        ErrorMessage message = this.messageStorage.getErrorMessage(key);
        message = this.validateMessage(message, key);
        Object[] messageParameters = this.validateParameters(message, key, parameters);
        try {
            text = String.format(message.getText(), messageParameters);
        }
        catch (IllegalFormatConversionException exception) {
            LOGGER.debug("Internal error: Invalid message format was used", (Throwable)exception);
            message = this.messageStorage.getErrorMessage(INVALID_MESSAGE_TEXT_FORMAT);
            message = this.validateMessage(message, key);
            messageParameters = this.validateParameters(message, key, parameters);
            text = String.format(message.getText(), messageParameters);
        }
        return new BasicMessage(key, message.getType(), message.getNumber(), text);
    }

    private ErrorMessage validateMessage(ErrorMessage message, String key) {
        if (message == null) {
            LOGGER.debug("Invalid message key '{}' was used. Please resolve this problem.", (Object)key);
            message = this.messageStorage.getErrorMessage(INVALID_KEY_MESSAGE);
        }
        if (message == null) {
            String text = "Internal error: Invalid message key '%s' provided. No default message found. Please contact CA support of further assistance.";
            message = new ErrorMessage(INVALID_KEY_MESSAGE, "MFS0001", MessageType.ERROR, text);
        }
        return message;
    }

    private Object[] validateParameters(ErrorMessage message, String key, Object ... parameters) {
        if (message.getKey().equals(INVALID_KEY_MESSAGE)) {
            return new Object[]{key};
        }
        return parameters;
    }
}

