/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.security;

import com.ca.mfaas.security.HttpsConfig;
import com.ca.mfaas.security.HttpsConfigError;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpsFactory.class);
    private static final String SAFKEYRING = "safkeyring";
    private HttpsConfig config;
    private SSLContext secureSslContext;

    public HttpsFactory(HttpsConfig httpsConfig) {
        this.config = httpsConfig;
        this.secureSslContext = null;
    }

    public CloseableHttpClient createSecureHttpClient() {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        socketFactoryRegistryBuilder.register("https", (Object)this.createSslSocketFactory());
        Registry socketFactoryRegistry = socketFactoryRegistryBuilder.build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(Objects.requireNonNull(socketFactoryRegistry));
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).disableCookieManagement().disableAuthCaching().build();
    }

    public ConnectionSocketFactory createSslSocketFactory() {
        if (this.config.isVerifySslCertificatesOfServices()) {
            return this.createSecureSslSocketFactory();
        }
        log.warn("The service is not verifying the TLS/SSL certificates of the services");
        return this.createIgnoringSslSocketFactory();
    }

    private ConnectionSocketFactory createIgnoringSslSocketFactory() {
        return new SSLConnectionSocketFactory(this.createIgnoringSslContext(), (HostnameVerifier)new NoopHostnameVerifier());
    }

    private SSLContext createIgnoringSslContext() {
        try {
            return new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new HttpsConfigError("Error initializing SSL/TLS context: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.SSL_CONTEXT_INITIALIZATION_FAILED, this.config);
        }
    }

    private void loadTrustMaterial(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (this.config.getTrustStore() != null) {
            sslContextBuilder.setKeyStoreType(this.config.getTrustStoreType()).setProtocol(this.config.getProtocol());
            if (!this.config.getTrustStore().startsWith(SAFKEYRING)) {
                if (this.config.getTrustStorePassword() == null) {
                    throw new HttpsConfigError("server.ssl.trustStorePassword configuration parameter is not defined", HttpsConfigError.ErrorCode.TRUSTSTORE_PASSWORD_NOT_DEFINED, this.config);
                }
                log.info("Loading trust store file: " + this.config.getTrustStore());
                File trustStoreFile = new File(this.config.getTrustStore());
                sslContextBuilder.loadTrustMaterial(trustStoreFile, this.config.getTrustStorePassword().toCharArray());
            } else {
                log.info("Loading trust store key ring: " + this.config.getTrustStore());
                sslContextBuilder.loadTrustMaterial(this.keyRingUrl(this.config.getTrustStore()), this.config.getTrustStorePassword() == null ? null : this.config.getTrustStorePassword().toCharArray());
            }
        } else {
            if (this.config.isTrustStoreRequired()) {
                throw new HttpsConfigError("server.ssl.trustStore configuration parameter is not defined but trust store is required", HttpsConfigError.ErrorCode.TRUSTSTORE_NOT_DEFINED, this.config);
            }
            log.info("No trust store is defined");
        }
    }

    private URL keyRingUrl(String uri) throws MalformedURLException {
        if (!uri.startsWith("safkeyring:////")) {
            throw new MalformedURLException("Incorrect key ring format: " + this.config.getTrustStore() + ". Make sure you use format safkeyring:////userId/keyRing");
        }
        return new URL(HttpsFactory.replaceFourSlashes(uri));
    }

    private void loadKeyMaterial(SSLContextBuilder sslContextBuilder) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        if (this.config.getKeyStore() != null) {
            sslContextBuilder.setKeyStoreType(this.config.getKeyStoreType()).setProtocol(this.config.getProtocol());
            if (!this.config.getKeyStore().startsWith(SAFKEYRING)) {
                this.loadKeystoreMaterial(sslContextBuilder);
            } else {
                this.loadKeyringMaterial(sslContextBuilder);
            }
        } else {
            log.info("No key store is defined");
        }
    }

    private void loadKeystoreMaterial(SSLContextBuilder sslContextBuilder) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (this.config.getKeyStore() == null) {
            throw new HttpsConfigError("server.ssl.keyStore configuration parameter is not defined", HttpsConfigError.ErrorCode.KEYSTORE_NOT_DEFINED, this.config);
        }
        if (this.config.getKeyStorePassword() == null) {
            throw new HttpsConfigError("server.ssl.keyStorePassword configuration parameter is not defined", HttpsConfigError.ErrorCode.KEYSTORE_PASSWORD_NOT_DEFINED, this.config);
        }
        log.info("Loading key store file: " + this.config.getKeyStore());
        File keyStoreFile = new File(this.config.getKeyStore());
        sslContextBuilder.loadKeyMaterial(keyStoreFile, this.config.getKeyStorePassword() == null ? null : this.config.getKeyStorePassword().toCharArray(), this.config.getKeyPassword() == null ? null : this.config.getKeyPassword().toCharArray());
    }

    private void loadKeyringMaterial(SSLContextBuilder sslContextBuilder) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        log.info("Loading trust key ring: " + this.config.getKeyStore());
        sslContextBuilder.loadKeyMaterial(this.keyRingUrl(this.config.getKeyStore()), this.config.getKeyStorePassword() == null ? null : this.config.getKeyStorePassword().toCharArray(), this.config.getKeyPassword() == null ? null : this.config.getKeyPassword().toCharArray(), null);
    }

    private synchronized SSLContext createSecureSslContext() {
        if (this.secureSslContext == null) {
            log.debug("Protocol: {}", (Object)this.config.getProtocol());
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            try {
                this.loadTrustMaterial(sslContextBuilder);
                this.loadKeyMaterial(sslContextBuilder);
                this.secureSslContext = sslContextBuilder.build();
                this.validateSslConfig();
                return this.secureSslContext;
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                log.error("Error initializing HTTP client: {}", (Object)e.getMessage(), (Object)e);
                throw new HttpsConfigError("Error initializing HTTP client: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, this.config);
            }
        }
        return this.secureSslContext;
    }

    private void validateSslConfig() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (this.config.getKeyAlias() != null) {
            InputStream istream;
            KeyStore ks = KeyStore.getInstance(this.config.getKeyStoreType());
            if (this.config.getKeyStore().startsWith(SAFKEYRING)) {
                URL url = this.keyRingUrl(this.config.getKeyStore());
                istream = url.openStream();
            } else {
                File keyStoreFile = new File(this.config.getKeyStore());
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, this.config.getKeyStorePassword() == null ? null : this.config.getKeyStorePassword().toCharArray());
            if (!ks.containsAlias(this.config.getKeyAlias())) {
                throw new HttpsConfigError(String.format("Invalid key alias '%s'", this.config.getKeyAlias()), HttpsConfigError.ErrorCode.WRONG_KEY_ALIAS, this.config);
            }
        }
    }

    private ConnectionSocketFactory createSecureSslSocketFactory() {
        return new SSLConnectionSocketFactory(this.createSecureSslContext(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    public SSLContext createSslContext() {
        if (this.config.isVerifySslCertificatesOfServices()) {
            return this.createSecureSslContext();
        }
        return this.createIgnoringSslContext();
    }

    private void setSystemProperty(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public void setSystemSslProperties() {
        this.setSystemProperty("javax.net.ssl.keyStore", HttpsFactory.replaceFourSlashes(this.config.getKeyStore()));
        this.setSystemProperty("javax.net.ssl.keyStorePassword", this.config.getKeyStorePassword());
        this.setSystemProperty("javax.net.ssl.keyStoreType", this.config.getKeyStoreType());
        this.setSystemProperty("javax.net.ssl.trustStore", HttpsFactory.replaceFourSlashes(this.config.getTrustStore()));
        this.setSystemProperty("javax.net.ssl.trustStorePassword", this.config.getTrustStorePassword());
        this.setSystemProperty("javax.net.ssl.trustStoreType", this.config.getTrustStoreType());
    }

    public static String replaceFourSlashes(String storeUri) {
        return storeUri == null ? null : storeUri.replaceFirst("////", "//");
    }

    public HostnameVerifier createHostnameVerifier() {
        if (this.config.isVerifySslCertificatesOfServices()) {
            return SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        }
        return new NoopHostnameVerifier();
    }

    public EurekaJerseyClientImpl.EurekaJerseyClientBuilder createEurekaJerseyClientBuilder(String eurekaServerUrl, String serviceId) {
        EurekaJerseyClientImpl.EurekaJerseyClientBuilder builder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder();
        builder.withClientName(serviceId);
        builder.withMaxTotalConnections(10);
        builder.withMaxConnectionsPerHost(10);
        if (eurekaServerUrl.startsWith("http://")) {
            log.warn("Unsecure HTTP is used to connect to Discovery Service");
        } else {
            System.setProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory", "true");
            this.setSystemSslProperties();
            builder.withCustomSSL(this.createSecureSslContext());
            builder.withHostnameVerifier(this.createHostnameVerifier());
        }
        return builder;
    }

    public String readSecret() {
        if (this.config.getKeyStore() == null) {
            return null;
        }
        try {
            InputStream istream;
            KeyStore ks = KeyStore.getInstance(this.config.getKeyStoreType());
            if (this.config.getKeyStore().startsWith(SAFKEYRING)) {
                URL url = this.keyRingUrl(this.config.getKeyStore());
                istream = url.openStream();
            } else {
                File keyStoreFile = new File(this.config.getKeyStore());
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, this.config.getKeyStorePassword() == null ? null : this.config.getKeyStorePassword().toCharArray());
            char[] keyPassword = this.config.getKeyPassword() == null ? null : this.config.getKeyPassword().toCharArray();
            Key key = null;
            if (this.config.getKeyAlias() != null) {
                key = ks.getKey(this.config.getKeyAlias(), keyPassword);
            } else {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    try {
                        key = ks.getKey(alias, keyPassword);
                        break;
                    }
                    catch (UnrecoverableKeyException uke) {
                        log.debug("Key with alias {} could not be used: {}", (Object)alias, (Object)uke.getMessage());
                    }
                }
            }
            if (key == null) {
                throw new UnrecoverableKeyException(String.format("No key with private key entry could be used in the keystore. Provided key alias: %s", this.config.getKeyAlias() == null ? "<not provided>" : this.config.getKeyAlias()));
            }
            return Base64.getEncoder().encodeToString(key.getEncoded());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error("Error reading secret key: {}", (Object)e.getMessage(), (Object)e);
            throw new HttpsConfigError("Error reading secret key: " + e.getMessage(), (Throwable)e, HttpsConfigError.ErrorCode.HTTP_CLIENT_INITIALIZATION_FAILED, this.config);
        }
    }

    @Generated
    public HttpsConfig getConfig() {
        return this.config;
    }

    @Generated
    public SSLContext getSecureSslContext() {
        return this.secureSslContext;
    }

    @Generated
    public void setConfig(HttpsConfig config) {
        this.config = config;
    }

    @Generated
    public void setSecureSslContext(SSLContext secureSslContext) {
        this.secureSslContext = secureSslContext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpsFactory)) {
            return false;
        }
        HttpsFactory other = (HttpsFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpsConfig this$config = this.getConfig();
        HttpsConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        SSLContext this$secureSslContext = this.getSecureSslContext();
        SSLContext other$secureSslContext = other.getSecureSslContext();
        return !(this$secureSslContext == null ? other$secureSslContext != null : !this$secureSslContext.equals(other$secureSslContext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpsFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpsConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        SSLContext $secureSslContext = this.getSecureSslContext();
        result = result * 59 + ($secureSslContext == null ? 43 : $secureSslContext.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpsFactory(config=" + this.getConfig() + ", secureSslContext=" + this.getSecureSslContext() + ")";
    }

    @Generated
    public HttpsFactory() {
    }
}

