/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.content;

import com.ca.apiml.security.common.content.AbstractSecureContentFilter;
import com.ca.apiml.security.common.error.ResourceAccessExceptionHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class BasicContentFilter
extends AbstractSecureContentFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicContentFilter.class);

    public BasicContentFilter(AuthenticationManager authenticationManager, AuthenticationFailureHandler failureHandler, ResourceAccessExceptionHandler resourceAccessExceptionHandler) {
        super(authenticationManager, failureHandler, resourceAccessExceptionHandler, new String[0]);
    }

    public BasicContentFilter(AuthenticationManager authenticationManager, AuthenticationFailureHandler failureHandler, ResourceAccessExceptionHandler resourceAccessExceptionHandler, String[] endpoints) {
        super(authenticationManager, failureHandler, resourceAccessExceptionHandler, endpoints);
    }

    @Override
    public Optional<AbstractAuthenticationToken> extractContent(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Authorization")).filter(header -> header.startsWith("Basic")).map(header -> header.replaceFirst("Basic", "").trim()).filter(base64Credentials -> !base64Credentials.isEmpty()).map(this::mapBase64Credentials);
    }

    private UsernamePasswordAuthenticationToken mapBase64Credentials(String base64Credentials) {
        String principal = null;
        String credentials = null;
        try {
            String decodedCredentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            int i = decodedCredentials.indexOf(58);
            if (i >= 0) {
                principal = decodedCredentials.substring(0, i);
                credentials = decodedCredentials.substring(i + 1);
            }
        }
        catch (Exception e) {
            log.debug("Conversion problem with the credentials {}", (Object)base64Credentials);
        }
        return new UsernamePasswordAuthenticationToken(principal, credentials);
    }
}

