/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.content;

import com.ca.apiml.security.common.config.AuthConfigurationProperties;
import com.ca.apiml.security.common.content.AbstractSecureContentFilter;
import com.ca.apiml.security.common.error.ResourceAccessExceptionHandler;
import com.ca.apiml.security.common.token.TokenAuthentication;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class CookieContentFilter
extends AbstractSecureContentFilter {
    private final AuthConfigurationProperties authConfigurationProperties;

    public CookieContentFilter(AuthenticationManager authenticationManager, AuthenticationFailureHandler failureHandler, ResourceAccessExceptionHandler resourceAccessExceptionHandler, AuthConfigurationProperties authConfigurationProperties) {
        super(authenticationManager, failureHandler, resourceAccessExceptionHandler, new String[0]);
        this.authConfigurationProperties = authConfigurationProperties;
    }

    public CookieContentFilter(AuthenticationManager authenticationManager, AuthenticationFailureHandler failureHandler, ResourceAccessExceptionHandler resourceAccessExceptionHandler, AuthConfigurationProperties authConfigurationProperties, String[] endpoints) {
        super(authenticationManager, failureHandler, resourceAccessExceptionHandler, endpoints);
        this.authConfigurationProperties = authConfigurationProperties;
    }

    @Override
    public Optional<AbstractAuthenticationToken> extractContent(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(this.authConfigurationProperties.getCookieProperties().getCookieName())).filter(cookie -> !cookie.getValue().isEmpty()).findFirst().map(cookie -> new TokenAuthentication(cookie.getValue()));
    }
}

