/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.error;

import com.ca.apiml.security.common.error.AbstractExceptionHandler;
import com.ca.apiml.security.common.error.ErrorType;
import com.ca.apiml.security.common.error.ServiceNotAccessibleException;
import com.ca.mfaas.error.ErrorService;
import com.ca.mfaas.product.gateway.GatewayNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ResourceAccessExceptionHandler
extends AbstractExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceAccessExceptionHandler.class);

    public ResourceAccessExceptionHandler(ErrorService errorService, ObjectMapper mapper) {
        super(errorService, mapper);
    }

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        if (ex instanceof GatewayNotFoundException) {
            this.handleGatewayNotFound(request, response, ex);
        } else if (ex instanceof ServiceNotAccessibleException) {
            this.handleServiceNotAccessible(request, response, ex);
        } else {
            throw ex;
        }
    }

    private void handleGatewayNotFound(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.GATEWAY_NOT_FOUND.getErrorMessageKey(), HttpStatus.NOT_FOUND, request, response);
    }

    private void handleServiceNotAccessible(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("500 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.SERVICE_UNAVAILABLE.getErrorMessageKey(), HttpStatus.SERVICE_UNAVAILABLE, request, response);
    }
}

