/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.error;

import com.ca.apiml.security.common.error.AbstractExceptionHandler;
import com.ca.apiml.security.common.error.AuthMethodNotSupportedException;
import com.ca.apiml.security.common.error.ErrorType;
import com.ca.apiml.security.common.token.TokenExpireException;
import com.ca.apiml.security.common.token.TokenNotProvidedException;
import com.ca.apiml.security.common.token.TokenNotValidException;
import com.ca.mfaas.message.api.ApiMessageView;
import com.ca.mfaas.message.core.MessageService;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class AuthExceptionHandler
extends AbstractExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthExceptionHandler.class);

    public AuthExceptionHandler(MessageService messageService, ObjectMapper objectMapper) {
        super(messageService, objectMapper);
    }

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        if (ex instanceof InsufficientAuthenticationException) {
            this.handleAuthenticationRequired(request, response, ex);
        } else if (ex instanceof BadCredentialsException) {
            this.handleBadCredentials(request, response, ex);
        } else if (ex instanceof AuthenticationCredentialsNotFoundException) {
            this.handleAuthenticationCredentialsNotFound(request, response, ex);
        } else if (ex instanceof AuthMethodNotSupportedException) {
            this.handleAuthMethodNotSupported(request, response, ex);
        } else if (ex instanceof TokenNotValidException) {
            this.handleTokenNotValid(request, response, ex);
        } else if (ex instanceof TokenNotProvidedException) {
            this.handleTokenNotProvided(request, response, ex);
        } else if (ex instanceof TokenExpireException) {
            this.handleTokenExpire(request, response, ex);
        } else if (ex instanceof AuthenticationException) {
            this.handleAuthenticationException(request, response, ex);
        } else {
            throw new ServletException((Throwable)ex);
        }
    }

    private void handleAuthenticationRequired(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.AUTH_REQUIRED.getErrorMessageKey(), HttpStatus.UNAUTHORIZED, request, response);
    }

    private void handleBadCredentials(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.BAD_CREDENTIALS.getErrorMessageKey(), HttpStatus.UNAUTHORIZED, request, response);
    }

    private void handleAuthenticationCredentialsNotFound(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.AUTH_CREDENTIALS_NOT_FOUND.getErrorMessageKey(), HttpStatus.BAD_REQUEST, request, response);
    }

    private void handleAuthMethodNotSupported(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        ApiMessageView message = this.messageService.createMessage(ErrorType.AUTH_METHOD_NOT_SUPPORTED.getErrorMessageKey(), new Object[]{ex.getMessage(), request.getRequestURI()}).mapToView();
        HttpStatus status = HttpStatus.METHOD_NOT_ALLOWED;
        this.writeErrorResponse(message, status, response);
    }

    private void handleTokenNotValid(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.TOKEN_NOT_VALID.getErrorMessageKey(), HttpStatus.UNAUTHORIZED, request, response);
    }

    private void handleTokenNotProvided(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.TOKEN_NOT_PROVIDED.getErrorMessageKey(), HttpStatus.UNAUTHORIZED, request, response);
    }

    private void handleTokenExpire(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.debug("400 Status Code: {}", (Object)ex.getMessage());
        this.writeErrorResponse(ErrorType.TOKEN_EXPIRED.getErrorMessageKey(), HttpStatus.UNAUTHORIZED, request, response);
    }

    private void handleAuthenticationException(HttpServletRequest request, HttpServletResponse response, RuntimeException ex) throws ServletException {
        log.error("500 Status Code: {}", (Object)ex.getMessage());
        log.debug("", (Throwable)ex);
        ApiMessageView message = this.messageService.createMessage(ErrorType.AUTH_GENERAL.getErrorMessageKey(), new Object[]{ex.getMessage(), request.getRequestURI()}).mapToView();
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        this.writeErrorResponse(message, status, response);
    }
}

