/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.error;

import com.ca.mfaas.message.api.ApiMessageView;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.HttpStatus;

public abstract class AbstractExceptionHandler {
    protected static final String ERROR_MESSAGE_400 = "400 Status Code: {}";
    protected static final String ERROR_MESSAGE_500 = "500 Status Code: {}";
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    protected final MessageService messageService;
    protected final ObjectMapper mapper;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    public abstract void handleException(HttpServletRequest var1, HttpServletResponse var2, RuntimeException var3) throws ServletException;

    protected void writeErrorResponse(String messageKey, HttpStatus status, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ApiMessageView message = this.messageService.createMessage(messageKey, new Object[]{request.getRequestURI()}).mapToView();
        this.writeErrorResponse(message, status, response);
    }

    protected void writeErrorResponse(ApiMessageView message, HttpStatus status, HttpServletResponse response) throws ServletException {
        response.setStatus(status.value());
        response.setContentType(CONTENT_TYPE);
        try {
            this.mapper.writeValue((Writer)response.getWriter(), (Object)message);
        }
        catch (IOException e) {
            this.apimlLog.log("apiml.security.errorWrittingResponse", new Object[]{e.getMessage()});
            throw new ServletException("Error writting response", (Throwable)e);
        }
    }

    @Generated
    public AbstractExceptionHandler(MessageService messageService, ObjectMapper mapper) {
        this.messageService = messageService;
        this.mapper = mapper;
    }
}

