/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apiml.security.common.config;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="apiml.security.auth", ignoreUnknownFields=false)
public class AuthConfigurationProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthConfigurationProperties.class);
    private String gatewayLoginEndpoint = "/api/v1/gateway/auth/login";
    private String gatewayQueryEndpoint = "/api/v1/gateway/auth/query";
    private String serviceLoginEndpoint = "/auth/login";
    private String serviceLogoutEndpoint = "/auth/logout";
    private TokenProperties tokenProperties;
    private CookieProperties cookieProperties = new CookieProperties();
    private String zosmfServiceId;
    private String provider = "zosmf";
    private String jwtKeyAlias;

    public AuthConfigurationProperties() {
        this.tokenProperties = new TokenProperties();
    }

    public String validatedZosmfServiceId() {
        if (this.zosmfServiceId == null || this.zosmfServiceId.isEmpty()) {
            log.error("z/OSMF service name not found. Set property apiml.security.auth.zosmfServiceId to your service name.");
            throw new AuthenticationServiceException("The parameter 'zosmfServiceId' is not configured.");
        }
        return this.zosmfServiceId;
    }

    @Generated
    public String getGatewayLoginEndpoint() {
        return this.gatewayLoginEndpoint;
    }

    @Generated
    public String getGatewayQueryEndpoint() {
        return this.gatewayQueryEndpoint;
    }

    @Generated
    public String getServiceLoginEndpoint() {
        return this.serviceLoginEndpoint;
    }

    @Generated
    public String getServiceLogoutEndpoint() {
        return this.serviceLogoutEndpoint;
    }

    @Generated
    public TokenProperties getTokenProperties() {
        return this.tokenProperties;
    }

    @Generated
    public CookieProperties getCookieProperties() {
        return this.cookieProperties;
    }

    @Generated
    public String getZosmfServiceId() {
        return this.zosmfServiceId;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getJwtKeyAlias() {
        return this.jwtKeyAlias;
    }

    @Generated
    public void setGatewayLoginEndpoint(String gatewayLoginEndpoint) {
        this.gatewayLoginEndpoint = gatewayLoginEndpoint;
    }

    @Generated
    public void setGatewayQueryEndpoint(String gatewayQueryEndpoint) {
        this.gatewayQueryEndpoint = gatewayQueryEndpoint;
    }

    @Generated
    public void setServiceLoginEndpoint(String serviceLoginEndpoint) {
        this.serviceLoginEndpoint = serviceLoginEndpoint;
    }

    @Generated
    public void setServiceLogoutEndpoint(String serviceLogoutEndpoint) {
        this.serviceLogoutEndpoint = serviceLogoutEndpoint;
    }

    @Generated
    public void setTokenProperties(TokenProperties tokenProperties) {
        this.tokenProperties = tokenProperties;
    }

    @Generated
    public void setCookieProperties(CookieProperties cookieProperties) {
        this.cookieProperties = cookieProperties;
    }

    @Generated
    public void setZosmfServiceId(String zosmfServiceId) {
        this.zosmfServiceId = zosmfServiceId;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setJwtKeyAlias(String jwtKeyAlias) {
        this.jwtKeyAlias = jwtKeyAlias;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthConfigurationProperties)) {
            return false;
        }
        AuthConfigurationProperties other = (AuthConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$gatewayLoginEndpoint = this.getGatewayLoginEndpoint();
        String other$gatewayLoginEndpoint = other.getGatewayLoginEndpoint();
        if (this$gatewayLoginEndpoint == null ? other$gatewayLoginEndpoint != null : !this$gatewayLoginEndpoint.equals(other$gatewayLoginEndpoint)) {
            return false;
        }
        String this$gatewayQueryEndpoint = this.getGatewayQueryEndpoint();
        String other$gatewayQueryEndpoint = other.getGatewayQueryEndpoint();
        if (this$gatewayQueryEndpoint == null ? other$gatewayQueryEndpoint != null : !this$gatewayQueryEndpoint.equals(other$gatewayQueryEndpoint)) {
            return false;
        }
        String this$serviceLoginEndpoint = this.getServiceLoginEndpoint();
        String other$serviceLoginEndpoint = other.getServiceLoginEndpoint();
        if (this$serviceLoginEndpoint == null ? other$serviceLoginEndpoint != null : !this$serviceLoginEndpoint.equals(other$serviceLoginEndpoint)) {
            return false;
        }
        String this$serviceLogoutEndpoint = this.getServiceLogoutEndpoint();
        String other$serviceLogoutEndpoint = other.getServiceLogoutEndpoint();
        if (this$serviceLogoutEndpoint == null ? other$serviceLogoutEndpoint != null : !this$serviceLogoutEndpoint.equals(other$serviceLogoutEndpoint)) {
            return false;
        }
        TokenProperties this$tokenProperties = this.getTokenProperties();
        TokenProperties other$tokenProperties = other.getTokenProperties();
        if (this$tokenProperties == null ? other$tokenProperties != null : !((Object)this$tokenProperties).equals(other$tokenProperties)) {
            return false;
        }
        CookieProperties this$cookieProperties = this.getCookieProperties();
        CookieProperties other$cookieProperties = other.getCookieProperties();
        if (this$cookieProperties == null ? other$cookieProperties != null : !((Object)this$cookieProperties).equals(other$cookieProperties)) {
            return false;
        }
        String this$zosmfServiceId = this.getZosmfServiceId();
        String other$zosmfServiceId = other.getZosmfServiceId();
        if (this$zosmfServiceId == null ? other$zosmfServiceId != null : !this$zosmfServiceId.equals(other$zosmfServiceId)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$jwtKeyAlias = this.getJwtKeyAlias();
        String other$jwtKeyAlias = other.getJwtKeyAlias();
        return !(this$jwtKeyAlias == null ? other$jwtKeyAlias != null : !this$jwtKeyAlias.equals(other$jwtKeyAlias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $gatewayLoginEndpoint = this.getGatewayLoginEndpoint();
        result = result * 59 + ($gatewayLoginEndpoint == null ? 43 : $gatewayLoginEndpoint.hashCode());
        String $gatewayQueryEndpoint = this.getGatewayQueryEndpoint();
        result = result * 59 + ($gatewayQueryEndpoint == null ? 43 : $gatewayQueryEndpoint.hashCode());
        String $serviceLoginEndpoint = this.getServiceLoginEndpoint();
        result = result * 59 + ($serviceLoginEndpoint == null ? 43 : $serviceLoginEndpoint.hashCode());
        String $serviceLogoutEndpoint = this.getServiceLogoutEndpoint();
        result = result * 59 + ($serviceLogoutEndpoint == null ? 43 : $serviceLogoutEndpoint.hashCode());
        TokenProperties $tokenProperties = this.getTokenProperties();
        result = result * 59 + ($tokenProperties == null ? 43 : ((Object)$tokenProperties).hashCode());
        CookieProperties $cookieProperties = this.getCookieProperties();
        result = result * 59 + ($cookieProperties == null ? 43 : ((Object)$cookieProperties).hashCode());
        String $zosmfServiceId = this.getZosmfServiceId();
        result = result * 59 + ($zosmfServiceId == null ? 43 : $zosmfServiceId.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $jwtKeyAlias = this.getJwtKeyAlias();
        result = result * 59 + ($jwtKeyAlias == null ? 43 : $jwtKeyAlias.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthConfigurationProperties(gatewayLoginEndpoint=" + this.getGatewayLoginEndpoint() + ", gatewayQueryEndpoint=" + this.getGatewayQueryEndpoint() + ", serviceLoginEndpoint=" + this.getServiceLoginEndpoint() + ", serviceLogoutEndpoint=" + this.getServiceLogoutEndpoint() + ", tokenProperties=" + this.getTokenProperties() + ", cookieProperties=" + this.getCookieProperties() + ", zosmfServiceId=" + this.getZosmfServiceId() + ", provider=" + this.getProvider() + ", jwtKeyAlias=" + this.getJwtKeyAlias() + ")";
    }

    public static class CookieProperties {
        private String cookieName = "apimlAuthenticationToken";
        private boolean cookieSecure = true;
        private String cookiePath = "/";
        private String cookieComment = "API Mediation Layer security token";
        private Integer cookieMaxAge = -1;

        @Generated
        public CookieProperties() {
        }

        @Generated
        public String getCookieName() {
            return this.cookieName;
        }

        @Generated
        public boolean isCookieSecure() {
            return this.cookieSecure;
        }

        @Generated
        public String getCookiePath() {
            return this.cookiePath;
        }

        @Generated
        public String getCookieComment() {
            return this.cookieComment;
        }

        @Generated
        public Integer getCookieMaxAge() {
            return this.cookieMaxAge;
        }

        @Generated
        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        @Generated
        public void setCookieSecure(boolean cookieSecure) {
            this.cookieSecure = cookieSecure;
        }

        @Generated
        public void setCookiePath(String cookiePath) {
            this.cookiePath = cookiePath;
        }

        @Generated
        public void setCookieComment(String cookieComment) {
            this.cookieComment = cookieComment;
        }

        @Generated
        public void setCookieMaxAge(Integer cookieMaxAge) {
            this.cookieMaxAge = cookieMaxAge;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CookieProperties)) {
                return false;
            }
            CookieProperties other = (CookieProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cookieName = this.getCookieName();
            String other$cookieName = other.getCookieName();
            if (this$cookieName == null ? other$cookieName != null : !this$cookieName.equals(other$cookieName)) {
                return false;
            }
            if (this.isCookieSecure() != other.isCookieSecure()) {
                return false;
            }
            String this$cookiePath = this.getCookiePath();
            String other$cookiePath = other.getCookiePath();
            if (this$cookiePath == null ? other$cookiePath != null : !this$cookiePath.equals(other$cookiePath)) {
                return false;
            }
            String this$cookieComment = this.getCookieComment();
            String other$cookieComment = other.getCookieComment();
            if (this$cookieComment == null ? other$cookieComment != null : !this$cookieComment.equals(other$cookieComment)) {
                return false;
            }
            Integer this$cookieMaxAge = this.getCookieMaxAge();
            Integer other$cookieMaxAge = other.getCookieMaxAge();
            return !(this$cookieMaxAge == null ? other$cookieMaxAge != null : !((Object)this$cookieMaxAge).equals(other$cookieMaxAge));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CookieProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cookieName = this.getCookieName();
            result = result * 59 + ($cookieName == null ? 43 : $cookieName.hashCode());
            result = result * 59 + (this.isCookieSecure() ? 79 : 97);
            String $cookiePath = this.getCookiePath();
            result = result * 59 + ($cookiePath == null ? 43 : $cookiePath.hashCode());
            String $cookieComment = this.getCookieComment();
            result = result * 59 + ($cookieComment == null ? 43 : $cookieComment.hashCode());
            Integer $cookieMaxAge = this.getCookieMaxAge();
            result = result * 59 + ($cookieMaxAge == null ? 43 : ((Object)$cookieMaxAge).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfigurationProperties.CookieProperties(cookieName=" + this.getCookieName() + ", cookieSecure=" + this.isCookieSecure() + ", cookiePath=" + this.getCookiePath() + ", cookieComment=" + this.getCookieComment() + ", cookieMaxAge=" + this.getCookieMaxAge() + ")";
        }
    }

    public static class TokenProperties {
        private int expirationInSeconds = 86400;
        private String issuer = "APIML";
        private String shortTtlUsername = "expire";
        private long shortTtlExpirationInSeconds = 1L;

        @Generated
        public TokenProperties() {
        }

        @Generated
        public int getExpirationInSeconds() {
            return this.expirationInSeconds;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public String getShortTtlUsername() {
            return this.shortTtlUsername;
        }

        @Generated
        public long getShortTtlExpirationInSeconds() {
            return this.shortTtlExpirationInSeconds;
        }

        @Generated
        public void setExpirationInSeconds(int expirationInSeconds) {
            this.expirationInSeconds = expirationInSeconds;
        }

        @Generated
        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Generated
        public void setShortTtlUsername(String shortTtlUsername) {
            this.shortTtlUsername = shortTtlUsername;
        }

        @Generated
        public void setShortTtlExpirationInSeconds(long shortTtlExpirationInSeconds) {
            this.shortTtlExpirationInSeconds = shortTtlExpirationInSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenProperties)) {
                return false;
            }
            TokenProperties other = (TokenProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpirationInSeconds() != other.getExpirationInSeconds()) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$shortTtlUsername = this.getShortTtlUsername();
            String other$shortTtlUsername = other.getShortTtlUsername();
            if (this$shortTtlUsername == null ? other$shortTtlUsername != null : !this$shortTtlUsername.equals(other$shortTtlUsername)) {
                return false;
            }
            return this.getShortTtlExpirationInSeconds() == other.getShortTtlExpirationInSeconds();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TokenProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpirationInSeconds();
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $shortTtlUsername = this.getShortTtlUsername();
            result = result * 59 + ($shortTtlUsername == null ? 43 : $shortTtlUsername.hashCode());
            long $shortTtlExpirationInSeconds = this.getShortTtlExpirationInSeconds();
            result = result * 59 + (int)($shortTtlExpirationInSeconds >>> 32 ^ $shortTtlExpirationInSeconds);
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfigurationProperties.TokenProperties(expirationInSeconds=" + this.getExpirationInSeconds() + ", issuer=" + this.getIssuer() + ", shortTtlUsername=" + this.getShortTtlUsername() + ", shortTtlExpirationInSeconds=" + this.getShortTtlExpirationInSeconds() + ")";
        }
    }
}

