/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.web;

import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import com.ca.mfaas.security.HttpsConfig;
import com.ca.mfaas.security.HttpsConfigError;
import com.ca.mfaas.security.HttpsFactory;
import com.ca.mfaas.security.SecurityUtils;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class HttpConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private String trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private String keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private String keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    private CloseableHttpClient secureHttpClient;
    private SSLContext secureSslContext;
    private HostnameVerifier secureHostnameVerifier;
    private EurekaJerseyClientImpl.EurekaJerseyClientBuilder eurekaJerseyClientBuilder;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    @PostConstruct
    public void init() {
        try {
            HttpsConfig httpsConfig = HttpsConfig.builder().protocol(this.protocol).keyAlias(this.keyAlias).keyStore(this.keyStore).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).build();
            log.info("Using HTTPS configuration: {}", (Object)httpsConfig.toString());
            HttpsFactory factory = new HttpsFactory(httpsConfig);
            this.secureHttpClient = factory.createSecureHttpClient();
            this.secureSslContext = factory.createSslContext();
            this.secureHostnameVerifier = factory.createHostnameVerifier();
            this.eurekaJerseyClientBuilder = factory.createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId);
            factory.setSystemSslProperties();
        }
        catch (HttpsConfigError e) {
            System.exit(1);
        }
        catch (Exception e) {
            this.apimlLog.log("apiml.common.unknownHttpsConfigError", new Object[]{e.getMessage()});
            System.exit(1);
        }
    }

    @Bean
    public SslContextFactory jettySslContextFactory() {
        SslContextFactory sslContextFactory = new SslContextFactory(SecurityUtils.replaceFourSlashes((String)this.keyStore));
        sslContextFactory.setProtocol(this.protocol);
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        sslContextFactory.setKeyStoreType(this.keyStoreType);
        sslContextFactory.setCertAlias(this.keyAlias);
        if (this.trustStore != null) {
            sslContextFactory.setTrustStorePath(SecurityUtils.replaceFourSlashes((String)this.trustStore));
            sslContextFactory.setTrustStoreType(this.trustStoreType);
            sslContextFactory.setTrustStorePassword(this.trustStorePassword);
        }
        log.debug("jettySslContextFactory: {}", (Object)sslContextFactory.dump());
        if (!this.verifySslCertificatesOfServices) {
            sslContextFactory.setTrustAll(true);
        }
        return sslContextFactory;
    }

    @Bean
    public RestTemplate restTemplate() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClient);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public CloseableHttpClient secureHttpClient() {
        return this.secureHttpClient;
    }

    @Bean
    public SSLContext secureSslContext() {
        return this.secureSslContext;
    }

    @Bean
    public HostnameVerifier secureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }

    @Bean
    public EurekaJerseyClient eurekaJerseyClient() {
        return this.eurekaJerseyClientBuilder.build();
    }
}

