/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.instance.lookup;

import com.ca.mfaas.product.instance.InstanceNotFoundException;
import com.ca.mfaas.product.instance.lookup.RetryException;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLookupExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceLookupExecutor.class);
    private final EurekaClient eurekaClient;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "InstanceLookupExecutor-Thread"));
    private final int initialDelay;
    private final int period;

    public InstanceLookupExecutor(EurekaClient eurekaClient) {
        this(eurekaClient, 100, 5000);
    }

    private InstanceInfo findEurekaInstance(String serviceId) {
        Application application = this.eurekaClient.getApplication(serviceId);
        if (application == null) {
            throw new InstanceNotFoundException("Service '" + serviceId + "' is not registered to Discovery Service");
        }
        List appInstances = application.getInstances();
        if (appInstances.isEmpty()) {
            throw new InstanceNotFoundException("'" + serviceId + "' has no running instances registered to Discovery Service");
        }
        return (InstanceInfo)appInstances.get(0);
    }

    public void run(String serviceId, Consumer<InstanceInfo> action, BiConsumer<Exception, Boolean> handleFailureConsumer) {
        log.debug("Started instance finder");
        this.executorService.scheduleAtFixedRate(() -> {
            try {
                InstanceInfo instanceInfo = this.findEurekaInstance(serviceId);
                log.debug("App found {}", (Object)instanceInfo.getAppName());
                action.accept(instanceInfo);
                this.executorService.shutdownNow();
            }
            catch (InstanceNotFoundException | RetryException e) {
                log.debug(e.getMessage());
                handleFailureConsumer.accept(e, false);
            }
            catch (Exception e) {
                this.executorService.shutdownNow();
                handleFailureConsumer.accept(e, true);
                log.debug("Unexpected exception while retrieving '{}' service from Eureka", (Object)serviceId);
            }
        }, this.initialDelay, this.period, TimeUnit.MILLISECONDS);
    }

    @Generated
    public InstanceLookupExecutor(EurekaClient eurekaClient, int initialDelay, int period) {
        this.eurekaClient = eurekaClient;
        this.initialDelay = initialDelay;
        this.period = period;
    }
}

