/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.routing.transform;

import com.ca.mfaas.product.gateway.GatewayConfigProperties;
import com.ca.mfaas.product.routing.RoutedService;
import com.ca.mfaas.product.routing.RoutedServices;
import com.ca.mfaas.product.routing.ServiceType;
import com.ca.mfaas.product.routing.transform.URLTransformationException;
import com.ca.mfaas.product.utils.UrlUtils;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransformService.class);
    private static final String SEPARATOR = "/";
    private final GatewayConfigProperties gatewayConfigProperties;

    public TransformService(GatewayConfigProperties gatewayConfigProperties) {
        this.gatewayConfigProperties = gatewayConfigProperties;
    }

    public String transformURL(ServiceType type, String serviceId, String serviceUrl, RoutedServices routes) throws URLTransformationException {
        String endPoint;
        URI serviceUri = URI.create(serviceUrl);
        String serviceUriPath = serviceUri.getPath();
        if (serviceUriPath == null) {
            String message = String.format("The URI %s is not valid.", serviceUri);
            throw new URLTransformationException(message);
        }
        RoutedService route = routes.getBestMatchingServiceUrl(serviceUriPath, type);
        if (route == null) {
            String message = String.format("Not able to select route for url %s of the service %s. Original url used.", serviceUri, serviceId);
            throw new URLTransformationException(message);
        }
        if (serviceUri.getQuery() != null) {
            serviceUriPath = serviceUriPath + "?" + serviceUri.getQuery();
        }
        if (!(endPoint = this.getShortEndPoint(route.getServiceUrl(), serviceUriPath)).isEmpty() && !endPoint.startsWith(SEPARATOR)) {
            throw new URLTransformationException("The path " + serviceUri.getPath() + " of the service URL " + serviceUri + " is not valid.");
        }
        return String.format("%s://%s/%s/%s%s", this.gatewayConfigProperties.getScheme(), this.gatewayConfigProperties.getHostname(), route.getGatewayUrl(), serviceId, endPoint);
    }

    private String getShortEndPoint(String routeServiceUrl, String endPoint) {
        String shortEndPoint = endPoint;
        if (!routeServiceUrl.equals(SEPARATOR)) {
            shortEndPoint = shortEndPoint.replaceFirst(UrlUtils.removeLastSlash(routeServiceUrl), "");
        }
        return shortEndPoint;
    }
}

