/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.message.yaml.YamlMessageServiceInstance;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public class ServiceStartupEventHandler {
    public static final int DEFAULT_DELAY_FACTOR = 5;
    private final ApimlLogger apimlLog = ApimlLogger.of(ServiceStartupEventHandler.class, (MessageService)YamlMessageServiceInstance.getInstance());

    public void onServiceStartup(String serviceName, int delayFactor) {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.apimlLog.log("apiml.common.serviceStarted", new Object[]{serviceName, (double)uptime / 1000.0});
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                String[] names;
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                for (String name : names = new String[]{"com.netflix.discovery.DiscoveryClient", "com.netflix.discovery.shared.transport.decorator.RedirectingEurekaHttpClient"}) {
                    Logger logger = loggerContext.getLogger(name);
                    logger.setLevel(Level.ERROR);
                }
            }
        }, uptime * 5L);
    }
}

