/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.logging;

import com.ca.mfaas.message.core.MessageService;
import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.message.yaml.YamlMessageServiceInstance;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class ApimlLogInjector
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, @Nonnull String name) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            if (field.getAnnotation(InjectApimlLogger.class) != null) {
                Class clazz = this.getClass(bean);
                ApimlLogger log = ApimlLogger.of((Class)clazz, (MessageService)YamlMessageServiceInstance.getInstance());
                field.set(bean, log);
            }
        });
        return bean;
    }

    private Class getClass(Object bean) {
        Class<Object> clazz = bean.getClass();
        String fullName = clazz.getName();
        int index = fullName.indexOf(36);
        if (index > -1) {
            String className = fullName.substring(0, index);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                clazz = ApimlLogInjector.class;
            }
        }
        return clazz;
    }

    @Generated
    public ApimlLogInjector() {
    }
}

