/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mfaas.product.gateway;

import com.ca.mfaas.message.log.ApimlLogger;
import com.ca.mfaas.product.constants.CoreService;
import com.ca.mfaas.product.gateway.GatewayClient;
import com.ca.mfaas.product.gateway.GatewayConfigProperties;
import com.ca.mfaas.product.gateway.GatewayLookupCompleteEvent;
import com.ca.mfaas.product.instance.InstanceInitializationException;
import com.ca.mfaas.product.instance.lookup.InstanceLookupExecutor;
import com.ca.mfaas.product.logging.annotations.InjectApimlLogger;
import com.netflix.appinfo.InstanceInfo;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;

public class GatewayInstanceInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayInstanceInitializer.class);
    private final InstanceLookupExecutor instanceLookupExecutor;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final GatewayClient gatewayClient;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    private GatewayConfigProperties process(InstanceInfo instanceInfo) {
        try {
            String gatewayHomePage = instanceInfo.getHomePageUrl();
            URI uri = new URI(gatewayHomePage);
            return GatewayConfigProperties.builder().scheme(uri.getScheme()).hostname(uri.getHost() + ":" + uri.getPort()).build();
        }
        catch (Exception e) {
            throw new InstanceInitializationException(e.getMessage());
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        if (this.gatewayClient.isInitialized()) {
            return;
        }
        log.info("GatewayInstanceInitializer starting asynchronous initialization of Gateway configuration");
        this.instanceLookupExecutor.run(CoreService.GATEWAY.getServiceId(), instance -> {
            GatewayConfigProperties foundGatewayConfigProperties = this.process((InstanceInfo)instance);
            log.info("GatewayInstanceInitializer has been initialized with Gateway instance on url: {}://{}", (Object)foundGatewayConfigProperties.getScheme(), (Object)foundGatewayConfigProperties.getHostname());
            this.gatewayClient.setGatewayConfigProperties(foundGatewayConfigProperties);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GatewayLookupCompleteEvent(this));
        }, (exception, isStopped) -> {
            if (Boolean.TRUE.equals(isStopped)) {
                this.apimlLog.log("apiml.common.gatewayInstanceInitializerStopped", new Object[]{exception.getMessage()});
            }
        });
    }

    @Generated
    public GatewayInstanceInitializer(InstanceLookupExecutor instanceLookupExecutor, ApplicationEventPublisher applicationEventPublisher, GatewayClient gatewayClient) {
        this.instanceLookupExecutor = instanceLookupExecutor;
        this.applicationEventPublisher = applicationEventPublisher;
        this.gatewayClient = gatewayClient;
    }
}

