/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import javax.servlet.Filter;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;

@Configuration
@ComponentScan(value={"org.zowe.apiml.security.common"})
@EnableWebSecurity
@Profile(value={"!https"})
public class HttpWebSecurityConfig
extends AbstractWebSecurityConfigurer {
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";
    @Value(value="${apiml.discovery.userid:eureka}")
    private String eurekaUserid;
    @Value(value="${apiml.discovery.password:password}")
    private String eurekaPassword;
    private final HandlerInitializer handlerInitializer;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.eurekaUserid).password("{noop}" + this.eurekaPassword).roles(new String[]{"EUREKA"});
    }

    public void configure(WebSecurity web) {
        String[] noSecurityAntMatchers = new String[]{"/favicon.ico", "/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**"};
        web.ignoring().antMatchers(noSecurityAntMatchers);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)this.baseConfigure(http).addFilterBefore((Filter)this.basicFilter(this.authenticationManager()), UsernamePasswordAuthenticationFilter.class).httpBasic().realmName(DISCOVERY_REALM).and()).authorizeRequests().antMatchers(new String[]{"/application/info", "/application/health"})).permitAll().antMatchers(new String[]{"/**"})).authenticated();
    }

    private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
        return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)this.handlerInitializer.getAuthenticationFailureHandler(), this.handlerInitializer.getResourceAccessExceptionHandler());
    }

    @Generated
    public HttpWebSecurityConfig(HandlerInitializer handlerInitializer) {
        this.handlerInitializer = handlerInitializer;
    }
}

